/** @file   enterhighscoresmenu.h
 * @brief   Declaration of EnterHighscoresMenu - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ENTERHIGHSCORESMENU_H
#define H_WWW_ENTERHIGHSCORESMENU_H

#include "highscoresmenu.h"
#include "highscoretable.h"


namespace WeWantWar {


/** @class  EnterHighscoresMenu
 * @brief   This menupage shows the highscores and asks player to type his name.
 * @author  Tomi Lamminsaari
 *
 * Shows the normal highscores menu if score is not high enough. If scores are
 * high enough, this asks player to type his name and stores it to the
 * table.
 */
class EnterHighscoresMenu : public HighscoresMenu
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   * @param     scores            Amount of score
   */
	EnterHighscoresMenu( int scores );


	/** Destructor
   */
	virtual ~EnterHighscoresMenu();

private:

	/** Copy constructor.
   * @param     rO                Reference to another EnterHighscoresMenu
   */
  EnterHighscoresMenu( const EnterHighscoresMenu& rO );

	/** Assignment operator
   * @param     rO                Reference to another EnterHighscoresMenu
   * @return    Reference to us.
   */
  EnterHighscoresMenu& operator = ( const EnterHighscoresMenu& rO );

public:


  ///
  /// Methods
  /// =======

  /** Redraws this page
   */
  virtual void redraw();
  


  ///
  /// Getter methods
  /// ==============


protected:

  /** The modes this menupage can be in
   */
  enum {
    /** We only show the highscores. */
    HSMODE_VIEW,
    /** We should ask the player to type his name. */
    HSMODE_ENTER
  };
  
  
  /** Initializes this menu
   */
  void initMenu();
  
  /** Updates the fadein state
   * @return    <code>MenuPage::NO_PAGE_CHANGE</code>
   */
  virtual int updateFadeInState();
  
  /** Updates the visible part
   * @return    <code>MenuPage::NO_PAGE_CHANGE</code>
   */
  virtual int updateVisibleState();
  
  /** Reads keyboard and modifies the name being types.
   */
  void editText();
  
  
  
  ///
  /// Members
  /// =======

  /** How much scores the player got */
  int m_scores;
  
  /** The current highscore table */
  HighscoreTable m_highscoretable;

  /** In which mode we're operating */
  int m_highscoremode;
  
  /** The string we're currently editing. */
  std::string m_editedName;
  
  /** Position of the cursor in the string we're editing. */
  int m_cursorPos;

private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: enterhighscoresmenu.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:55+02  lamminsa
 * Initial revision
 *
 */
 
